<?php
/**
 * pagos_adelantados_apply.php (BÁSICO + sin triggers)
 *
 * Unión real:
 *   mantenimientopago.ID  <->  mantenimientopagodetalle.InvID (varchar(11))
 *
 * 1) Contable:
 *   - Sumar el monto TOTAL al Totalpagado del detalle del base_id (mes actual).
 *
 * 2) Operativo:
 *   - Aplicar el saldo a cuotas pendientes (atrasados/futuros según prioridad) actualizando mantenimientopago.
 *   - NO sumar Totalpagado en meses destino (evita doble conteo en reportes por mes).
 *
 * 3) Reemplazo del trigger Cuotaestatus (en PHP):
 *   - si Pagorestante entre -2 y 2 => Pagado
 *   - else if Adjuntarimagen != 'NULL' AND Pagoparcial='0' => Revision
 *   - else => No Pagado
 *   - si cambia el status => Enviar = '1'
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', '0');

include 'dbconnection.php';

function out($ok, $arr = array()){
  echo json_encode(array_merge(array('ok'=>$ok), $arr), JSON_UNESCAPED_UNICODE);
  exit;
}
function esc($con, $v){ return mysqli_real_escape_string($con, (string)$v); }
function dec($v){
  $s = str_replace(' ', '', (string)$v);
  if (strpos($s, ',') !== false && strpos($s, '.') === false) $s = str_replace(',', '.', $s);
  else $s = str_replace(',', '', $s);
  return (float)$s;
}
function mesNum($mes){
  $m = strtolower(trim((string)$mes));
  $map = array('enero'=>1,'febrero'=>2,'marzo'=>3,'abril'=>4,'mayo'=>5,'junio'=>6,'julio'=>7,'agosto'=>8,'septiembre'=>9,'setiembre'=>9,'octubre'=>10,'noviembre'=>11,'diciembre'=>12);
  return isset($map[$m]) ? $map[$m] : 0;
}
function keyYM($ano,$mes){
  $mm = mesNum($mes);
  $yy = (int)$ano;
  if ($mm<=0 || $yy<=0) return 0;
  return ($yy*100)+$mm;
}
function calcStatus($pagorestante, $adjuntarimagen, $pagoparcial){
  // lógica del trigger Cuotaestatus
  if ($pagorestante <= 2 && $pagorestante >= -2) return 'Pagado';
  // en tu trigger comparas con 'NULL' string
  if ((string)$adjuntarimagen !== 'NULL' && (string)$pagoparcial === '0') return 'Revision';
  return 'No Pagado';
}

/* ===== Inputs ===== */
$condominio = $_POST['condominio'] ?? '';
$residencia = $_POST['residencia'] ?? '';
$base_id    = $_POST['base_id'] ?? '';
$mes        = $_POST['mes'] ?? '';
$ano        = $_POST['ano'] ?? '';
$prioridad  = $_POST['prioridad'] ?? 'atrasados';
$total      = dec($_POST['total'] ?? 0);

if (!$condominio || !$residencia || !$base_id) out(false, array('error'=>'Faltan datos (condominio/residencia/base_id).'));
if ($total <= 0) out(false, array('error'=>'Monto inválido.'));
$startKey = keyYM($ano,$mes);
if ($startKey <= 0) out(false, array('error'=>'Mes/Año inválidos.'));

$escCon  = esc($con, $condominio);
$escRes  = esc($con, $residencia);
$escBase = esc($con, $base_id);
$fecha   = date('Y-m-d');

$baseInt = (int)$base_id;
$rsBase = mysqli_query($con, "SELECT ID, Mes, Ano FROM mantenimientopago WHERE ID={$baseInt} LIMIT 1");
if (!$rsBase) out(false, array('error'=>'DB: no puedo leer mantenimientopago base: '.mysqli_error($con)));
if (!mysqli_fetch_assoc($rsBase)) out(false, array('error'=>"No existe mantenimientopago.ID = {$baseInt}"));

/* ===== 1) CONTABLE: sumar Totalpagado del base_id ===== */
$det = mysqli_query($con, "SELECT InvID FROM mantenimientopagodetalle WHERE InvID='{$escBase}' LIMIT 1");
if (!$det) out(false, array('error'=>'DB: error leyendo detalle base: '.mysqli_error($con)));

// Si el detalle no existe, NO intentamos inventar todos los campos NOT NULL.
// (Tu tabla tiene muchos campos: Amount, Qty, Items, etc.)
// En vez de insertar a ciegas, devolvemos error claro.
if (mysqli_num_rows($det) == 0){
  out(false, array(
    'error'=>'No existe mantenimientopagodetalle para este ID (InvID='.$base_id.'). Primero debe existir la fila detalle base.'
  ));
}

$updDet = mysqli_query($con, "
  UPDATE mantenimientopagodetalle
  SET Totalpagado = IFNULL(Totalpagado,0) + {$total},
      Tipodepago  = 'Pago Adelantado (Ingreso Mes Actual)'
  WHERE InvID = '{$escBase}'
  LIMIT 1
");
if (!$updDet) out(false, array('error'=>'DB: error actualizando Totalpagado (detalle base): '.mysqli_error($con)));

/* ===== 2) Cargar cuotas pendientes ===== */
$rs = mysqli_query($con, "
  SELECT ID, Mes, Ano, InvTotal, Pagorealizado, Pagorestante, Pagostatus, Pagoparcial, Adjuntarimagen
  FROM mantenimientopago
  WHERE Condominio='{$escCon}'
    AND Residencia='{$escRes}'
    AND (Pagostatus IS NULL OR Pagostatus <> 'Pagado')
");
if (!$rs) out(false, array('error'=>'DB: error leyendo cuotas pendientes: '.mysqli_error($con)));

$atras = array();
$fut   = array();

while ($r = mysqli_fetch_assoc($rs)) {
  $k = keyYM($r['Ano'], $r['Mes']);
  if ($k <= 0) continue;

  $rest = dec($r['Pagorestante']);
  if ($rest <= 0) $rest = dec($r['InvTotal']) - dec($r['Pagorealizado']);
  if ($rest <= 0) continue;

  $r['_key']  = $k;
  $r['_rest'] = $rest;

  if ($k < $startKey) $atras[] = $r;
  else $fut[] = $r;
}

usort($atras, function($a,$b){ return $a['_key'] <=> $b['_key']; });
usort($fut,   function($a,$b){ return $a['_key'] <=> $b['_key']; });

$cola = ($prioridad === 'futuros') ? array_merge($fut, $atras) : array_merge($atras, $fut);

if (count($cola) === 0){
  out(true, array(
    'message'=>'No hay cuotas pendientes para aplicar.',
    'ingreso_mes_actual'=>$total,
    'aplicado_operativo'=>0,
    'sobrante'=>$total,
    'aplicaciones'=>array()
  ));
}

/* ===== 3) Aplicación operativa ===== */
$saldo = round($total, 2);
$aplicado = 0.0;
$aplicaciones = array();

foreach ($cola as $c) {
  if ($saldo <= 0) break;

  $ap = ($saldo < $c['_rest']) ? $saldo : $c['_rest'];
  $ap = round($ap, 2);

  $nuevoPagado = round(dec($c['Pagorealizado']) + $ap, 2);
  $nuevoRest   = round($c['_rest'] - $ap, 2);

  $nuevoParcial = ($nuevoRest > 0) ? '1' : '0';
  $nuevoStatus  = calcStatus($nuevoRest, $c['Adjuntarimagen'], $nuevoParcial);

  $statusOld = (string)($c['Pagostatus'] ?? '');
  $enviar = ($nuevoStatus !== $statusOld) ? '1' : '0';

  $id = (int)$c['ID'];

  $up = mysqli_query($con, "
    UPDATE mantenimientopago
    SET Pagorealizado = {$nuevoPagado},
        Pagorestante  = {$nuevoRest},
        Pagoparcial   = '{$nuevoParcial}',
        Pagostatus    = '{$nuevoStatus}',
        Enviar        = '{$enviar}',
        Fechapago     = '{$fecha}'
    WHERE ID = {$id}
    LIMIT 1
  ");
  if (!$up) out(false, array('error'=>"DB: error aplicando a ID {$id}: ".mysqli_error($con)));

  // Marcar detalle destino si existe (sin sumar Totalpagado)
  $idInv = esc($con, (string)$c['ID']);
  $tipo  = ($c['_key'] < $startKey) ? 'Aplicación Atrasados (sin ingreso)' : 'Aplicación Futuros (sin ingreso)';
  @mysqli_query($con, "UPDATE mantenimientopagodetalle SET Estatus='{$nuevoStatus}', Tipodepago='{$tipo}' WHERE InvID='{$idInv}' LIMIT 1");

  $saldo = round($saldo - $ap, 2);
  $aplicado = round($aplicado + $ap, 2);

  $aplicaciones[] = array(
    'ID' => (string)$c['ID'],
    'Mes' => $c['Mes'],
    'Ano' => $c['Ano'],
    'Aplicado' => $ap,
    'Restante' => ($nuevoRest < 0 ? 0 : $nuevoRest),
    'Estado' => $nuevoStatus
  );
}

out(true, array(
  'message'=>'Pago aplicado correctamente.',
  'base_id'=>(string)$base_id,
  'ingreso_mes_actual'=>$total,
  'aplicado_operativo'=>$aplicado,
  'sobrante'=>$saldo,
  'aplicaciones'=>$aplicaciones
));
