<!DOCTYPE html>
<?php
include 'dbconnection.php';

$resultMes = mysqli_query($con, "SELECT * FROM mes");
$resultAno = mysqli_query($con, "SELECT * FROM ano");

$Condominio = isset($_GET["Condominio"]) ? $_GET["Condominio"] : '';
$Residencia = isset($_GET["Residencia"]) ? $_GET["Residencia"] : '';
$BaseID     = isset($_GET["ID"]) ? $_GET["ID"] : ''; // mantenimientopago.ID (union)
?>

<div style="width:50%;margin:auto;">

  <form id="frmPagoAdelantado" class="form-horizontal" autocomplete="off">

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Aplicar desde Mes :</label><br>
    <select name="mes" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="">------- Seleccionar -------</option>
      <?php while($m = mysqli_fetch_array($resultMes)): ?>
        <option value="<?php echo $m[1]; ?>"><?php echo $m[1]; ?></option>
      <?php endwhile; ?>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Año :</label><br>
    <select name="ano" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="">------- Seleccionar -------</option>
      <?php while($a = mysqli_fetch_array($resultAno)): ?>
        <option value="<?php echo $a[1]; ?>"><?php echo $a[1]; ?></option>
      <?php endwhile; ?>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Aplicar primero en :</label><br>
    <select name="prioridad" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="futuros" selected>Meses futuros</option>
      <option value="atrasados">Meses atrasados</option>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Monto :</label><br>
    <input type="number" step="0.01" name="total" style="margin-bottom:10px;width:100%;height:24px;" placeholder="0.00" required>

    <input type="hidden" name="condominio" value="<?php echo htmlspecialchars($Condominio, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="residencia" value="<?php echo htmlspecialchars($Residencia, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="base_id" value="<?php echo htmlspecialchars($BaseID, ENT_QUOTES, 'UTF-8'); ?>">

    <div id="msgBox" style="display:none; margin-top:10px; padding:10px; border-radius:8px; font-size:12px; line-height:1.35;"></div>

    <div align="center" style="margin-top:12px;">
      <button type="submit" id="btnEnviar" class="btn btn-default btn-sm" style="border-color:#f29f41;font-size:12px;">
        <i class="fa fa-file-import fa-lg"></i> Enviar
      </button>
    </div>

  </form>
</div>

<style>
select { text-align:center; text-align-last:center; }
option { text-align:left; }
</style>

<script>
(function(){

  function showErr(html){
    $('#msgBox').html(html).show().css({background:'#ffecec', border:'1px solid #ffb3b3', color:'#8a1f1f'});
  }
  function showOk(html){
    $('#msgBox').html(html).show().css({background:'#e8fff0', border:'1px solid #b6f0c7', color:'#126b2f'});
  }

  // compat: no arrow functions
  function closeAndRefresh(){
    try { if (window.parent && window.parent.$) window.parent.$('.modal:visible').modal('hide'); } catch(e){}
    try { if (window.parent) window.parent.location.reload(); else location.reload(); } catch(e){ location.reload(); }
  }

  $(document).on('submit', '#frmPagoAdelantado', function(e){
    e.preventDefault();

    $('#msgBox').hide();
    $('#btnEnviar').prop('disabled', true).text('Procesando...');

    // IMPORTANTE: endpoint relativo (evita errores de origin/rutas)
    $.ajax({
      url: 'pagos_adelantados_apply.php',
      type: 'POST',
      data: $(this).serialize(),
      dataType: 'json',
      cache: false
    })
    .done(function(resp){
      if (resp && resp.ok) {
        var html = '✅ <b>Pago aplicado</b><br>';
        if (resp.aplicaciones && resp.aplicaciones.length) {
          html += '<br><b>Meses aplicados:</b><ul style="margin:6px 0 0 18px;">';
          for (var i=0; i<resp.aplicaciones.length; i++) {
            html += '<li>'+resp.aplicaciones[i].Mes+' '+resp.aplicaciones[i].Ano+' → <b>'+resp.aplicaciones[i].Aplicado+'</b></li>';
          }
          html += '</ul>';
        }
        showOk(html);
        setTimeout(closeAndRefresh, 1200);
      } else {
        showErr('<b>Error:</b> ' + (resp && resp.error ? resp.error : 'Respuesta inválida'));
      }
    })
    .fail(function(xhr){
      showErr('<b>Error AJAX</b><br><pre style="white-space:pre-wrap;max-height:220px;overflow:auto;">'+(xhr.responseText || '')+'</pre>');
    })
    .always(function(){
      $('#btnEnviar').prop('disabled', false).html('<i class="fa fa-file-import fa-lg"></i> Enviar');
    });

  });

})();
</script>
