<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class SingleSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check() && Auth::user()->last_session_id && $request->session()->getId() !== Auth::user()->last_session_id) {
            Auth::logout();
            // Optionally redirect to login page with a message
            return redirect('/user/login')->with(['message' => 'Se desconectó porque inició sesión desde otro dispositivo.', 'status' => 'success']);
        }

        return $next($request);
    }
}
