<?php namespace App\Http\Controllers;
use DB;
use Carbon\Carbon;
use App\Models\Registrodepagosmant;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Validator, Input, Redirect ; 


class RegistrodepagosmantController extends Controller {

	protected $layout = "layouts.main";
	protected $data = array();	
	public $module = 'registrodepagosmant';
	static $per_page	= '300';

	public function __construct()
	{		
		parent::__construct();
		$this->model = new Registrodepagosmant();	
		$this->modelview = new  \App\Models\Registrodepagosmantdetalles();
		$this->info = $this->model->makeInfo( $this->module);	
		$this->data = array(
			'pageTitle'	=> 	$this->info['title'],
			'pageNote'	=>  $this->info['note'],
			'pageModule'=> 'registrodepagosmant',
			'return'	=> self::returnUrl()
			
		);
		$this->data['subgrid']	= (isset($this->info['config']['subgrid']) ? $this->info['config']['subgrid'][0] : array()); 
	}

	public function index( Request $request )
	{
		// Make Sure users Logged 
		if(!\Auth::check()) 
			return redirect('user/login')->with('status', 'error')->with('message','You are not login');
		$this->grab( $request) ;
		if($this->access['is_view'] ==0) 
			return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');				
		// Render into template
		return view( $this->module.'.index',$this->data);
	}	

	function create( Request $request , $id =0 ) 
	{
		$this->hook( $request  );
		if($this->access['is_add'] ==0) 
			return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');

		$this->data['row'] = $this->model->getColumnTable( $this->info['table']); 
		
	 	$relation_key = $this->modelview->makeInfo($this->info['config']['subform']['module']);
	 	$this->data['accesschild'] = $this->modelview->validAccess($relation_key['id'] , session('gid'));	
	 	$this->data['relation_key'] = $relation_key['key'];
	 	$this->data['subform'] = $this->detailview($this->modelview ,  $this->info['config']['subform'] ,$id );
		$this->data['id'] = '';
		return view($this->module.'.form',$this->data);
	}
	function edit( Request $request , $id ) 
	{
		$this->hook( $request , $id );
		if(!isset($this->data['row']))
			return redirect($this->module)->with('message','Record Not Found !')->with('status','error');
		if($this->access['is_edit'] ==0 )
			return redirect('dashboard')->with('message',__('core.note_restric'))->with('status','error');
		$this->data['row'] = (array) $this->data['row'];
		
	 	$relation_key = $this->modelview->makeInfo($this->info['config']['subform']['module']);
	 	$this->data['accesschild'] = $this->modelview->validAccess($relation_key['id'] , session('gid'));	
	 	$this->data['relation_key'] = $relation_key['key'];
	 	$this->data['subform'] = $this->detailview($this->modelview ,  $this->info['config']['subform'] ,$id );
		$this->data['id'] = $id;
		return view($this->module.'.form',$this->data);
	}	
	function show( Request $request , $id ) 
	{
		/* Handle import , export and view */
		$task =$id ;
		switch( $task)
		{
			case 'search':
				return $this->getSearch();
				break;
			case 'lookup':
				return $this->getLookup($request );
				break;
			case 'comboselect':
				return $this->getComboselect( $request );
				break;
			case 'import':
				return $this->getImport( $request );
				break;
			case 'export':
				return $this->getExport( $request );
				break;
			default:
				$this->hook( $request , $id );
				if(!isset($this->data['row']))
					return redirect($this->module)->with('message','Record Not Found !')->with('status','error');

				if($this->access['is_detail'] ==0) 
					return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');

				return view($this->module.'.view',$this->data);	
				break;		
		}
	}
	function store( Request $request  )
	{
		$task = $request->input('action_task');
		switch ($task)
		{
			default:
				$rules = $this->validateForm();
				$validator = Validator::make($request->all(), $rules);
				if ($validator->passes()) 
				{
					$data = $this->validatePost( $request );
					$id = $this->model->insertRow($data , $request->input( $this->info['key']));
					$this->detailviewsave( $this->modelview , $request->all() ,$this->info['config']['subform'] , $id) ;
					
			/*	Suma de pago de Cuotas */
				             
				              $Mes = DB::table('mantenimientopago')->select('Mes')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Mes")); 
				              $Ano = DB::table('mantenimientopago')->select('Ano')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Ano"));                               
				                                             
				            
				
					          $x = DB::table('mantenimientopagodetalle')->where([
                                  
                                                                    ['InvID','=', $id],
                                                                   // ['Mes','=', $Mes],
                                                                   // ['Ano','=', $Ano],
                                                                    
                                                                    ])
					                                                    
					                                                    
                                                                        ->value(DB::raw("SUM(Amount*Qty)"));
                                                                        
                              $y = DB::table('mantenimientopagodetalle')->where([
                                  
                                                                    ['InvID','=', $id],
                                                                   // ['Mes','=', $Mes],
                                                                   // ['Ano','=', $Ano],
                                                                    
                                                                    ])
                                                                    
                                                                    ->value(DB::raw("SUM(Totalpagado)"));
                                                                        
                              $z = $x-$y;
					
					            DB::table('mantenimientopago')->where('ID', $id)->update(['InvTotal' => $x]);
					            DB::table('mantenimientopago')->where('ID', $id)->update(['Pagorealizado' => $y]);
					            DB::table('mantenimientopago')->where('ID', $id)->update(['Pagorestante' => $z]);
					            
					            DB::table('mantenimientopago')->where('ID', $id)->update(['Medestatus' =>'1']);
					            
					            
					            
				/* Suma de pago de Cuotas */
				
				/* Actualizacion de Condominio y Residencias en mantenimientopagodetalle */
				
				 $Residencia = DB::table('mantenimientopago')->select('Residencia')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Residencia")); 
				                                             
				 $Condominio = DB::table('mantenimientopago')->select('Condominio')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Condominio")); 
				                                             
				 DB::table('mantenimientopagodetalle')->where('InvID', $id)->whereNull('Condominio') 
				                                                           ->update(['Condominio' => $Condominio]);
				                                                           
				 
				 DB::table('mantenimientopagodetalle')->where('InvID', $id)->whereNull('Residencia') 
				                                                           ->update(['Residencia' => $Residencia]);
				 
				 /* Actualizacion de Condominio y Residencias en mantenimientopagodetalle */
				 
				 
				 
				 
				 /* Actualizacion de info y entryby */
				 
				 $Nombres1 = DB::table('residentes')->select('Nombres')
				                                             ->where('Condominio','=', $Condominio)
				                                             ->where('Residencia','=', $Residencia)
				                                             ->value(DB::raw("Nombres")); 
				                                             
				 $Apellidos1 = DB::table('residentes')->select('Apellidos')
				                                             ->where('Condominio','=', $Condominio)
				                                             ->where('Residencia','=', $Residencia)
				                                             ->value(DB::raw("Apellidos")); 
				                                             
				 $Email1 = DB::table('residentes')->select('Email')
				                                             ->where('Condominio','=', $Condominio)
				                                             ->where('Residencia','=', $Residencia)
				                                             ->value(DB::raw("Email")); 
				                                             
				 $Entryby = DB::table('tb_users')->select('id')
			                                             ->where('email','=', $Email1)
				                                         ->value(DB::raw("id"));                                            
				                                             
				                                             
				                                             
				 DB::table('mantenimientopagodetalle')->where('InvID', $id)->whereNull('Nombres') 
				                                                           ->update(['Nombres' => $Nombres1]);
				                                                           
				 
				 DB::table('mantenimientopagodetalle')->where('InvID', $id)->whereNull('Apellidos') 
				                                                           ->update(['Apellidos' => $Apellidos1]);                                            
				                                             
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Nombres') 
				                                                           ->update(['Nombres' => $Nombres1]);
				                                                           
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Apellidos') 
				                                                           ->update(['Apellidos' => $Apellidos1]); 
				                                                           
				                                                           
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Email') 
				                                                           ->update(['Email' => $Email1]);    
				                                                           
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('entry_by') 
				                                                 ->update(['entry_by' => $Entryby]);                                            
				 
				 
				 /* Actualizacion de info y entryby */ 
				 
				 
				  
				 
				 /* Actualizacion de fecha de Entrada */
				 
				 $Tipocuota = DB::table('mantenimientopago')->select('Tipocuota')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Tipocuota")); 
				                                             
				if($Mes =='Enero'){
				    
				 $Mesgen1 = 'Jan-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-01-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				                                                 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);   
				}elseif($Mes =='Febrero'){
				    
				 $Mesgen1 = 'Feb-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-02-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Marzo'){
				    
				 $Mesgen1 = 'Mar-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-03-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Abril'){
				    
				 $Mesgen1 = 'Apr-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-04-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Mayo'){
				    
				 $Mesgen1 = 'May-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-05-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Junio'){
				    
				 $Mesgen1 = 'Jun-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-06-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Julio'){
				    
				 $Mesgen1 = 'Jul-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-07-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);    
				}elseif($Mes =='Agosto'){
				    
				 $Mesgen1 = 'Aug-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-08-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);                                                                
				}elseif($Mes =='Septiembre'){
				    
				 $Mesgen1 = 'Sep-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-09-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);                                                                
				}elseif($Mes =='Octubre'){
				    
				 $Mesgen1 = 'Oct-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-10-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);                                                                
				}elseif($Mes =='Noviembre'){
				    
				 $Mesgen1 = 'Nov-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-11-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);                                                                
				}elseif($Mes =='Diciembre'){
				    
				 $Mesgen1 = 'Dec-'.$Ano;
				 
				 $Mesgen2 =  $Ano.'-12-01';
				 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('Mes2') 
				                                                 ->update(['Mes2' => $Mesgen1]); 
				 DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $Mesgen2]);                                                                
				}else{ }                                                                   
				                                             
				                                             
				                                             
				 /* Actualizacion de fecha de Entrada */                                            
				                                             
				                                             
				                                             
				                                             
				                                             
				                                
				/* $datecuotaext = Carbon::now();                                            
				 
			     $datecuotanormal = Carbon::parse($datecuotaext)->format('Y-m-01');
			     
			     
			     if($Tipocuota == 'Normal'){
			         
			      DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $datecuotanormal]);    
			         
			     }else{
			         
			       // DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 //->update(['fechadeentrada' => $datecuotaext]);
				   DB::table('mantenimientopago')->where('ID', $id)->whereNull('fechadeentrada') 
				                                                 ->update(['fechadeentrada' => $datecuotanormal]);     
			         
			     }*/
			     
			     
				 
				 
				 
				 
				 
				 
				 
				 
				 /* Actualizacion de Estatus en mantenimientopagodetalle */
				 
				 
				 
				 
				 /* $Estatus = DB::table('mantenimientopago')->select('Pagostatus')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Pagostatus")); 
				                                             
				  DB::table('mantenimientopagodetalle')->where('InvID','=', $id)
				                                       ->where('Amount','<=','Totalpagado')
				                                       ->update(['Estatus' => $Estatus]);  
				                                       
				                                       
				  $Pagorestante = DB::table('mantenimientopago')->select('Pagorestante')
				                                             ->where('ID','=', $id)
				                                             ->value(DB::raw("Pagorestante"));
				                                             
				 if($Pagorestante <= '1' || $Pagorestante >= '-1' ){
					    
				 DB::table('mantenimientopago')->where('ID', $id)->update(['Pagostatus' => 'Pagado']);   
			
				 }else{
				     
				 DB::table('mantenimientopago')->where('ID', $id)->update(['Pagostatus' => 'No Pagado']);     
				     
				 }  */                                            
				                                       
				                                       
				                                       
				                                       
				                                       
				                                       
				                                             
				 /* Actualizacion de Estatus en mantenimientopagodetalle */
				 
				 
				                                                           
				 /*$Actualizar =   DB::table('mantenimientopagodetalle')->select()
				                                                     ->where('InvID','=', $id)
				                                                     ->get()
				                                                     ->groupBy('Mes')
				                                                     ->count();  */
				
				
				

				
				
				
				
					
					/* Insert logs */
					$this->model->logs($request , $id);
					if(!is_null($request->input('apply')))
						return redirect( $this->module .'/'.$id.'/edit?'. $this->returnUrl() )->with('message',__('core.note_success'))->with('status','success');

					return redirect( $this->module .'?'. $this->returnUrl() )->with('message',__('core.note_success'))->with('status','success');
				} 
				else {
					return redirect($this->module.'/'. $request->input(  $this->info['key'] ).'/edit')
							->with('message',__('core.note_error'))->with('status','error')
							->withErrors($validator)->withInput();

				}
				break;
			case 'public':
				return $this->store_public( $request );
				break;

			case 'delete':
				$result = $this->destroy( $request );
				return redirect($this->module.'?'.$this->returnUrl())->with($result);
				break;

			case 'import':
				return $this->PostImport( $request );
				break;

			case 'copy':
				$result = $this->copy( $request );
				return redirect($this->module.'?'.$this->returnUrl())->with($result);
				break;		
		}	
	
	}	

	public function destroy( $request)
	{
		// Make Sure users Logged 
		if(!\Auth::check()) 
			return redirect('user/login')->with('status', 'error')->with('message','You are not login');

		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));
		if($this->access['is_remove'] ==0) 
			return redirect('dashboard')
				->with('message', __('core.note_restric'))->with('status','error');
		// delete multipe rows 
		if(count($request->input('ids')) >=1)
		{
			$this->model->destroy($request->input('ids'));
			\DB::table('mantenimientopagodetalle')->whereIn('InvID',$request->input('ids'))->delete();
			\SiteHelpers::auditTrail( $request , "ID : ".implode(",",$request->input('ids'))."  , Has Been Removed Successfull");
			// redirect
        	return ['message'=>__('core.note_success_delete'),'status'=>'success'];	
	
		} else {
			return ['message'=>__('No Item Deleted'),'status'=>'error'];				
		}

	}	
	
	public static function display(  )
	{
		$mode  = isset($_GET['view']) ? 'view' : 'default' ;
		$model  = new Registrodepagosmant();
		$info = $model::makeInfo('registrodepagosmant');
		$data = array(
			'pageTitle'	=> 	$info['title'],
			'pageNote'	=>  $info['note']			
		);	
		if($mode == 'view')
		{
			$id = $_GET['view'];
			$row = $model::getRow($id);
			if($row)
			{
				$data['row'] =  $row;
				$data['fields'] 		=  \SiteHelpers::fieldLang($info['config']['grid']);
				$data['id'] = $id;
				return view('registrodepagosmant.public.view',$data);			
			}			
		} 
		else {

			$page = isset($_GET['page']) ? $_GET['page'] : 1;
			$params = array(
				'page'		=> $page ,
				'limit'		=>  (isset($_GET['rows']) ? filter_var($_GET['rows'],FILTER_VALIDATE_INT) : 10 ) ,
				'sort'		=> $info['key'] ,
				'order'		=> 'asc',
				'params'	=> '',
				'global'	=> 1 
			);

			$result = $model::getRows( $params );
			$data['tableGrid'] 	= $info['config']['grid'];
			$data['rowData'] 	= $result['rows'];	

			$page = $page >= 1 && filter_var($page, FILTER_VALIDATE_INT) !== false ? $page : 1;	
			$pagination = new Paginator($result['rows'], $result['total'], $params['limit']);	
			$pagination->setPath('');
			$data['i']			= ($page * $params['limit'])- $params['limit']; 
			$data['pagination'] = $pagination;
			return view('registrodepagosmant.public.index',$data);	
		}

	}
	function store_public( $request)
	{
		
		$rules = $this->validateForm();
		$validator = Validator::make($request->all(), $rules);	
		if ($validator->passes()) {
			$data = $this->validatePost(  $request );		
			 $this->model->insertRow($data , $request->input('id'));
			return  Redirect::back()->with('message',__('core.note_success'))->with('status','success');
		} else {

			return  Redirect::back()->with('message',__('core.note_error'))->with('status','error')
			->withErrors($validator)->withInput();

		}	
	
	}
}
