@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'condominio?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<ul class="nav nav-tabs"><li class="active"><a href="#InformacionGeneral" data-toggle="tab">Informacion General</a></li>
				<li class=""><a href="#InformacionAdicional" data-toggle="tab">Informacion Adicional</a></li>
				</ul><div class="tab-content"><div class="tab-pane m-t active" id="InformacionGeneral"> 
				{!! Form::hidden('CondominioID', $row['CondominioID']) !!}					
									  <div class="form-group  " >
										<label for="Nombre" class=" control-label col-md-4 text-left"> Nombre <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Nombre' id='Nombre' value='{{ $row['Nombre'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Dirección" class=" control-label col-md-4 text-left"> Dirección <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Direccion' id='Direccion' value='{{ $row['Direccion'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Sector" class=" control-label col-md-4 text-left"> Sector <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Sector' id='Sector' value='{{ $row['Sector'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Provincia" class=" control-label col-md-4 text-left"> Provincia <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Provincia' rows='5' id='Provincia' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Estatus" class=" control-label col-md-4 text-left"> Estatus <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
					<?php $Estatus = explode(',',$row['Estatus']);
					$Estatus_opt = array( 'Activo' => 'Activo' ,  'Inactivo' => 'Inactivo' , ); ?>
					<select name='Estatus' rows='5' required  class='select2 '  > 
						<?php 
						foreach($Estatus_opt as $key=>$val)
						{
							echo "<option  value ='$key' ".($row['Estatus'] == $key ? " selected='selected' " : '' ).">$val</option>"; 						
						}						
						?></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Generación con Mediciones?" class=" control-label col-md-4 text-left"> Generación con Mediciones? <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
					<?php $Envioauto = explode(',',$row['Envioauto']);
					$Envioauto_opt = array( '0' => 'No' ,  '1' => 'Si' , ); ?>
					<select name='Envioauto' rows='5'   class='select2 '  > 
						<?php 
						foreach($Envioauto_opt as $key=>$val)
						{
							echo "<option  value ='$key' ".($row['Envioauto'] == $key ? " selected='selected' " : '' ).">$val</option>"; 						
						}						
						?></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 
			</div>
			
			<div class="tab-pane m-t " id="InformacionAdicional"> 
									
									  <div class="form-group  " >
										<label for="Fecha de Limite" class=" control-label col-md-4 text-left"> Fecha de Limite <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Fechadecobro' id='Fechadecobro' value='{{ $row['Fechadecobro'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Fecha de Extención" class=" control-label col-md-4 text-left"> Fecha de Extención <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Fechadeextencion' id='Fechadeextencion' value='{{ $row['Fechadeextencion'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 
			</div>
			
			

		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		
		
		$("#Provincia").jCombo("{!! url('condominio/comboselect?filter=provincias:Provincias:Provincias') !!}",
		{  selected_value : '{{ $row["Provincia"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("condominio/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop