@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'gestionbancariados?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<div class="col-md-12">
						<fieldset><legend> Gestion Bancaria II</legend>
				{!! Form::hidden('BancoID', $row['BancoID']) !!}					
									  <div class="form-group  " >
										<label for="Condominio" class=" control-label col-md-4 text-left"> Condominio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Condominio' rows='5' id='Condominio' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Mes" class=" control-label col-md-4 text-left"> Mes <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Mes' rows='5' id='Mes' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Ano" class=" control-label col-md-4 text-left"> Ano <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Ano' rows='5' id='Ano' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Periodo Inicial" class=" control-label col-md-4 text-left"> Periodo Inicial <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
				<div class="input-group m-b" style="width:150px !important;">
					{!! Form::text('Periodoinicial', $row['Periodoinicial'],array('class'=>'form-control input-sm date')) !!}
					<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
				</div> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Periodo Final" class=" control-label col-md-4 text-left"> Periodo Final <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
				<div class="input-group m-b" style="width:150px !important;">
					{!! Form::text('Periodofinal', $row['Periodofinal'],array('class'=>'form-control input-sm date')) !!}
					<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
				</div> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Total" class=" control-label col-md-4 text-left"> Total <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Total' id='Total' value='{{ $row['Total'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Documento" class=" control-label col-md-4 text-left"> Documento <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='file' name='Documento' id='Documento' class='inputfile  @if($row['Documento'] =='') class='required' @endif '  />

							<label for='Documento'><i class='fa fa-upload'></i> Choose a file</label>
							<div class='Documento_preview'></div>
					 	<div >
						{!! SiteHelpers::showUploadedFile($row['Documento'],'/uploads/estados/') !!}
						
						</div>					
					 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> </fieldset>
			</div>
			
			
			
	@if($accesschild['is_add'] == '1' && $accesschild['is_edit'] == '1' )
	<hr />
	<div class="clr clear"></div>
	
	<h5> Detalles </h5>
	
	<div class="table-responsive">
    <table class="table table-striped ">
        <thead>
			<tr>
				@foreach ($subform['tableGrid'] as $t)
					@if($t['view'] =='1' && $t['field'] !='Bancodetalles' && $t['field'] != $relation_key)
						<th>{{ $t['label'] }}</th>
					@endif
				@endforeach
				<th></th>	
			  </tr>

        </thead>

        <tbody>
        @if(count($subform['rowData'])>=1)
            @foreach ($subform['rowData'] as $rows)
            <tr class="clone clonedInput">
									
			 @foreach ($subform['tableGrid'] as $field)
				 @if($field['view'] =='1' && $field['field'] !='Bancodetalles' && $field['field'] != $relation_key)
				 <td>					 
				 	{!! SiteHelpers::bulkForm($field['field'] , $subform['tableForm'] , $rows->{$field['field']}) !!}							 
				 </td>
				 @endif					 
			 
			 @endforeach
			 <td>
			 	<a onclick=" $(this).parents('.clonedInput').remove(); return false" href="#" class="remove btn btn-xs btn-danger">-</a>
			 	<input type="hidden" name="counter[]">
			 	<input type="hidden" name="bulk_{{ $relation_key}}[]" value="{{  $rows->{$relation_key} }}" >
			 </td>
			@endforeach
			</tr> 

		@else
            <tr class="clone clonedInput">
									
			 @foreach ($subform['tableGrid'] as $field)

				 @if($field['view'] =='1' && $field['field'] !='Bancodetalles' && $field['field'] != $relation_key)
				 <td>					 
				 	{!! SiteHelpers::bulkForm($field['field'] , $subform['tableForm'] ) !!}							 
				 </td>
				 @endif					 
			 
			 @endforeach
			 <td>
			 	<a onclick=" $(this).parents('.clonedInput').remove(); return false" href="#" class="remove btn btn-xs btn-danger">-</a>
			 	<input type="hidden" name="counter[]">
			 	<input type="hidden" name="bulk_{{ $relation_key}}[]" value="" >
			 </td>
			
			</tr> 

		
		@endif	


        </tbody>	

     </table>  
     <input type="hidden" name="enable-masterdetail" value="true">
     </div>
	<br /><br />
     
     <a href="javascript:void(0);" class="addC btn btn-xs btn-info" rel=".clone"><i class="fa fa-plus"></i> New Item</a>
     <hr />
	@endif
    
		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		$('.addC').relCopy({});
		
		$("#Condominio").jCombo("{!! url('gestionbancariados/comboselect?filter=condominios:Nombre:Nombre') !!}",
		{  selected_value : '{{ $row["Condominio"] }}' });
		
		$("#Mes").jCombo("{!! url('gestionbancariados/comboselect?filter=mes:Mes:Mes') !!}",
		{  selected_value : '{{ $row["Mes"] }}' });
		
		$("#Ano").jCombo("{!! url('gestionbancariados/comboselect?filter=ano:Ano:Ano') !!}",
		{  selected_value : '{{ $row["Ano"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("gestionbancariados/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop