@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> View  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">
	
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools pull-left" >
		   		<a href="{{ ($prevnext['prev'] != '' ? url('gestionbancariadosdetalles/'.$prevnext['prev'].'?return='.$return ) : '#') }}" class="tips btn btn-sm"><i class="fa fa-arrow-left"></i>  </a>	
				<a href="{{ ($prevnext['next'] != '' ? url('gestionbancariadosdetalles/'.$prevnext['next'].'?return='.$return ) : '#') }}" class="tips btn btn-sm "> <i class="fa fa-arrow-right"></i>  </a>					
			</div>	

			<div class="sbox-tools" >
				@if($access['is_add'] ==1)
		   		<a href="{{ url('gestionbancariadosdetalles/'.$id.'/edit?return='.$return) }}" class="tips btn btn-sm  " title="{{ __('core.btn_edit') }}"><i class="fa  fa-pencil"></i></a>
				@endif
				<a href="{{ url('gestionbancariadosdetalles?return='.$return) }}" class="tips btn btn-sm  " title="{{ __('core.btn_back') }}"><i class="fa  fa-times"></i></a>		
			</div>
		</div>
		<div class="sbox-content">
			<div class="table-responsive">
				<table class="table table-striped " >
					<tbody>	
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('BancodetID', (isset($fields['BancodetID']['language'])? $fields['BancodetID']['language'] : array())) }}</td>
						<td>{{ $row->BancodetID}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Bancodetalles', (isset($fields['Bancodetalles']['language'])? $fields['Bancodetalles']['language'] : array())) }}</td>
						<td>{{ $row->Bancodetalles}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Item', (isset($fields['Item']['language'])? $fields['Item']['language'] : array())) }}</td>
						<td>{{ $row->Item}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Suplidor', (isset($fields['Suplidor']['language'])? $fields['Suplidor']['language'] : array())) }}</td>
						<td>{{ $row->Suplidor}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Tipo de Transacción', (isset($fields['tipotrans']['language'])? $fields['tipotrans']['language'] : array())) }}</td>
						<td>{{ $row->tipotrans}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Total', (isset($fields['Total']['language'])? $fields['Total']['language'] : array())) }}</td>
						<td>{{ $row->Total}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Condominio', (isset($fields['Condominio']['language'])? $fields['Condominio']['language'] : array())) }}</td>
						<td>{{ $row->Condominio}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Mes', (isset($fields['Mes']['language'])? $fields['Mes']['language'] : array())) }}</td>
						<td>{{ $row->Mes}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Ano', (isset($fields['Ano']['language'])? $fields['Ano']['language'] : array())) }}</td>
						<td>{{ $row->Ano}} </td>
						
					</tr>
				
					</tbody>	
				</table>   

			 	

			</div>
		</div>
	</div>
	</div>
</div>
@stop
